#!/usr/bin/perl

######################################################################
##                                                                  ##
## YourShop IDTracker - Copyright SunnyScript - All rights reserved ##
## SunnyScript is a subsidiary of Star Enterprise                   ##
##                                                                  ##
## Legal agreements... http://www.sunnyscript.com/terms.htm         ##
## Visit our website... http://www.sunnyscript.com                  ##
##                                                                  ##
######################################################################
##                                                                  ##
## CONFIGURATION:                                                   ##
##                                                                  ##
## 1. Look to the first line and replace /usr/bin/perl with your    ##
## path to Perl (ask your provider if you don't know where Perl is  ##
## located on the server).                                          ##
##                                                                  ##
## 2. Edit the following two variables to configure the software    ##
## according your requirements...                                   ##
##                                                                  ##
## homepage     This is the location of your main website (the site ##
##              that should appear after the cookie is set).        ##
##              Please use a complete URL (http://www...).          ##
## expires      Enter the time in days the cookie remains on        ##
##              client's computer (if a person bookmarks your site  ##
##              and comes back later, the affiliate still gets the  ##
##              commission). Set it to "0" and the cookie will be   ##
##              deleted after the browser software is closed.       ##
##                                                                  ##
######################################################################

$homepage = 'http://www.sunnyscript.com';
$expires = 10;

######################################################################
##                                                                  ##
## Don't change anything below this line. It may cause errors.      ##
##                                                                  ##
######################################################################

%input = &User_Data();

$affiliate = $input{'id'};

@days = ("Sun","Mon","Tue","Wed","Thu","Fri","Sat");
@months = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
	
	($seconds,$min,$hour,$mday,$mon,$year,$wday) = gmtime(time()+($expires*86400));
	$seconds = "0" . $seconds if ($seconds < 10);
	$min = "0" . $min if ($min < 10); 
	$hour = "0" . $hour if ($hour < 10); 
	$year += ($year < 50) ? 2000 : 1900; 
	$expdate = "$days[$wday], $mday-$months[$mon]-$year $hour:$min:$seconds GMT ";

	print "Set-Cookie: AFFILIATE=$affiliate; ";
	print "expires=$expdate; " if ($expires);
	print "path=/; \n";
	print "Location: $homepage\n\n";

sub User_Data {
  local (%user_data, $user_string, $name_value_pair, @name_value_pairs, $name, $value);

  if ($ENV{'REQUEST_METHOD'} eq "POST") {
    read(STDIN,$user_string,$ENV{'CONTENT_LENGTH'});
  } else {
    $user_string = $ENV{'QUERY_STRING'};
  }

  $user_string =~ s/\+/ /g;

  @name_value_pairs = split(/&/, $user_string);

  foreach $name_value_pair (@name_value_pairs) {
    ($name, $value) = split(/=/, $name_value_pair);

    $name =~
      s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/ge;
    $value =~
      s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/ge;

    if (defined($user_data{$name})) {
      $user_data{$name} .= ":" . $value;
    } else {
      $user_data{$name} = $value;
    }
  }
  return %user_data;
}
